/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWMergeType;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWParamExpressionCellEditor;
import filenet.vw.toolkit.design.property.workflow.VWBaseFieldTableModel;
import filenet.vw.toolkit.design.property.workflow.VWTableItemWrapper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWDataFieldItem;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import java.awt.ComponentOrientation;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;

public class VWFieldTableModel
extends VWBaseFieldTableModel
implements IVWPropertyChangeListener {
    private static final int NUM_COLUMNS = 6;
    public static final int COL_SOURCE = 0;
    public static final int COL_NAME = 1;
    public static final int COL_TYPE = 2;
    public static final int COL_MERGE_TYPE = 3;
    public static final int COL_VALUE = 4;
    public static final int COL_DESCRIPTION = 5;
    private JComboBox m_fieldTypeComboBox = null;
    private DefaultComboBoxModel m_twoMergeTypeModel = null;
    private DefaultComboBoxModel m_threeMergeTypeModel = null;
    private DefaultComboBoxModel m_fiveMergeTypeModel = null;
    private DefaultComboBoxModel m_sixMergeTypeModel = null;
    private DefaultComboBoxModel m_currentMergeTypeModel = null;
    private String m_dummyType = null;
    private String m_dummyValue = null;
    private String m_dummyMergeType = null;
    private String m_dummyDescription = null;

    public VWFieldTableModel(VWAuthPropertyData authPropertyData) {
        super(authPropertyData);
        try {
            this.m_dummyType = VWFieldType.getLocalizedString(4);
            this.m_dummyValue = "true";
            this.m_dummyMergeType = VWMergeType.getLocalizedString(3);
            this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public JComboBox getFieldTypeComboBox() {
        try {
            if (this.m_fieldTypeComboBox == null) {
                this.m_fieldTypeComboBox = new JComboBox();
                this.m_fieldTypeComboBox.setRenderer(new VWLabelListCellRenderer());
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(4));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(4) + "[ ]");
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(8));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(8) + "[ ]");
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(1));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(1) + "[ ]");
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(2));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(2) + "[ ]");
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(16));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(16) + "[ ]");
                ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
                this.m_fieldTypeComboBox.applyComponentOrientation(compOrientation);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_fieldTypeComboBox;
    }

    public DefaultComboBoxModel getMergeTypeComboBoxModel(int nRowIndex) {
        try {
            VWTableItemWrapper wrapper;
            if (this.m_twoMergeTypeModel == null) {
                this.m_twoMergeTypeModel = new DefaultComboBoxModel();
                this.m_twoMergeTypeModel.addElement(VWMergeType.getLocalizedString(1));
                this.m_twoMergeTypeModel.addElement(VWMergeType.getLocalizedString(3));
                this.m_threeMergeTypeModel = new DefaultComboBoxModel();
                this.m_threeMergeTypeModel.addElement(VWMergeType.getLocalizedString(1));
                this.m_threeMergeTypeModel.addElement(VWMergeType.getLocalizedString(3));
                this.m_threeMergeTypeModel.addElement(VWMergeType.getLocalizedString(5));
                this.m_fiveMergeTypeModel = new DefaultComboBoxModel();
                this.m_fiveMergeTypeModel.addElement(VWMergeType.getLocalizedString(1));
                this.m_fiveMergeTypeModel.addElement(VWMergeType.getLocalizedString(3));
                this.m_fiveMergeTypeModel.addElement(VWMergeType.getLocalizedString(4));
                this.m_fiveMergeTypeModel.addElement(VWMergeType.getLocalizedString(2));
                this.m_fiveMergeTypeModel.addElement(VWMergeType.getLocalizedString(6));
                this.m_sixMergeTypeModel = new DefaultComboBoxModel();
                this.m_sixMergeTypeModel.addElement(VWMergeType.getLocalizedString(1));
                this.m_sixMergeTypeModel.addElement(VWMergeType.getLocalizedString(3));
                this.m_sixMergeTypeModel.addElement(VWMergeType.getLocalizedString(4));
                this.m_sixMergeTypeModel.addElement(VWMergeType.getLocalizedString(2));
                this.m_sixMergeTypeModel.addElement(VWMergeType.getLocalizedString(6));
                this.m_sixMergeTypeModel.addElement(VWMergeType.getLocalizedString(5));
            }
            if ((wrapper = this.getTableItemAt(nRowIndex)) != null && wrapper.getValue() != null) {
                VWFieldDefinition fieldDef = (VWFieldDefinition)wrapper.getValue();
                if (fieldDef != null) {
                    this.getNewMergeType(fieldDef.getFieldType(), fieldDef.isArray(), fieldDef.getMergeType());
                }
            } else {
                this.getNewMergeType(this.getFieldType(this.m_dummyType), this.isArrayType(this.m_dummyType), this.getMergeType(this.m_dummyMergeType));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_currentMergeTypeModel;
    }

    public String getCurrentFieldType() {
        return this.m_dummyType;
    }

    public boolean isArrayType(String type) {
        boolean result = false;
        try {
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(4) + "[ ]") == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(8) + "[ ]") == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(1) + "[ ]") == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(2) + "[ ]") == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(16) + "[ ]") == 0) {
                result = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return result;
    }

    public int getFieldType(String type) {
        try {
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(4)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(4) + "[ ]") == 0) {
                return 4;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(8)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(8) + "[ ]") == 0) {
                return 8;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(1)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(1) + "[ ]") == 0) {
                return 1;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(2)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(2) + "[ ]") == 0) {
                return 2;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(16)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(16) + "[ ]") == 0) {
                return 16;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return -1;
    }

    public VWFieldDefinition getItemAt(int nRowIndex) {
        VWFieldDefinition fieldDef = null;
        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
        if (wrapper != null && wrapper.getValue() != null) {
            fieldDef = (VWFieldDefinition)wrapper.getValue();
        }
        return fieldDef;
    }

    public void copyItem(int nRowIndex) {
        block4: {
            try {
                VWFieldDefinition fieldDef;
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && wrapper.getValue() != null && (fieldDef = (VWFieldDefinition)wrapper.getValue()) != null && this.m_authPropertyData != null && this.m_authPropertyData.getWorkflowDefinition() != null) {
                    String fieldDefName = VWResource.s_copyOfFieldName.toString(fieldDef.getName());
                    VWFieldDefinition newFieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingString(fieldDefName, fieldDef.getStringValue(), fieldDef.getFieldType(), fieldDef.isArray());
                    if (newFieldDef != null) {
                        newFieldDef.setMergeType(fieldDef.getMergeType());
                        newFieldDef.setDescription(fieldDef.getDescription());
                        this.m_authPropertyData.resetFieldCache();
                        this.m_authPropertyData.setDirty();
                        this.m_rowData.addElement(new VWTableItemWrapper(0, newFieldDef));
                        nRowIndex = this.getRowCount() - 2;
                        this.fireTableRowsInserted(nRowIndex, nRowIndex);
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(newFieldDef);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 511);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block4;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    public void deleteItem(int nRowIndex) {
        block6: {
            try {
                VWFieldDefinition fieldDef;
                if (!this.canDeleteRow(nRowIndex)) {
                    return;
                }
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && wrapper.canDelete() && (fieldDef = (VWFieldDefinition)wrapper.getValue()) != null) {
                    this.m_authPropertyData.getWorkflowDefinition().deleteField(fieldDef.getName());
                    this.m_authPropertyData.resetFieldCache();
                    this.m_authPropertyData.setDirty();
                    if (wrapper.isOverridden()) {
                        wrapper.deleteOverriddenValue();
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    } else {
                        this.m_rowData.removeElementAt(nRowIndex);
                        this.fireTableRowsDeleted(nRowIndex, nRowIndex);
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(fieldDef);
                        this.onRemovedFields(this.m_changedItems);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 513);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block6;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    public void addItem(int nRowIndex, Object aValue) {
        try {
            if (aValue == null || !(aValue instanceof VWDataFieldItem)) {
                return;
            }
            VWDataFieldItem dataFieldItem = (VWDataFieldItem)aValue;
            String newValue = VWParamExpressionCellEditor.getInitialFieldValue(dataFieldItem.getType(), false);
            VWFieldDefinition newFieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingString(dataFieldItem.getName(), newValue, dataFieldItem.getType(), false);
            if (newFieldDef != null) {
                this.m_authPropertyData.resetFieldCache();
                this.m_authPropertyData.setDirty();
                this.m_rowData.addElement(new VWTableItemWrapper(0, newFieldDef));
                this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(newFieldDef);
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 511);
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
        }
    }

    public void reinitialize() {
        try {
            super.reinitialize();
            if (this.m_authPropertyData != null) {
                int i;
                VWFieldDefinition[] fieldDefs;
                if (this.m_authPropertyData.getShowInheritedProperties() && (fieldDefs = this.m_authPropertyData.getFields(2)) != null) {
                    block10: for (i = 0; i < fieldDefs.length; ++i) {
                        switch (fieldDefs[i].getFieldType()) {
                            case 32: 
                            case 64: 
                            case 128: {
                                continue block10;
                            }
                            case 1: 
                            case 2: 
                            case 4: 
                            case 8: 
                            case 16: {
                                this.m_rowData.addElement(new VWTableItemWrapper(1, fieldDefs[i]));
                            }
                        }
                    }
                }
                if ((fieldDefs = this.m_authPropertyData.getFields(1)) != null) {
                    block11: for (i = 0; i < fieldDefs.length; ++i) {
                        switch (fieldDefs[i].getFieldType()) {
                            case 32: 
                            case 64: 
                            case 128: {
                                continue block11;
                            }
                            case 1: 
                            case 2: 
                            case 4: 
                            case 8: 
                            case 16: {
                                int nIndex = this.findIndex(fieldDefs[i].getName());
                                if (nIndex != -1) {
                                    this.overrideTableItem(nIndex, fieldDefs[i]);
                                    continue block11;
                                }
                                this.m_rowData.addElement(new VWTableItemWrapper(0, fieldDefs[i]));
                                continue block11;
                            }
                        }
                    }
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 0: {
                return Icon.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 6 - this.m_nColumnIndexOffset;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: {
                return VWResource.s_nameStr;
            }
            case 2: {
                return VWResource.s_typeStr;
            }
            case 4: {
                return VWResource.s_expressionStr;
            }
            case 3: {
                return VWResource.s_mergeType;
            }
            case 5: {
                return VWResource.s_descriptionStr;
            }
        }
        return null;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWFieldDefinition fieldDef = null;
            VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
            if (wrapper != null && wrapper.getValue() != null) {
                fieldDef = (VWFieldDefinition)wrapper.getValue();
            }
            switch (nColumnIndex + this.m_nColumnIndexOffset) {
                case 0: {
                    if (wrapper == null) break;
                    return wrapper.getStateIcon();
                }
                case 1: {
                    if (fieldDef == null) break;
                    return fieldDef.getName();
                }
                case 2: {
                    return this.getTypeField(fieldDef);
                }
                case 4: {
                    return this.getValueField(fieldDef);
                }
                case 3: {
                    if (fieldDef != null) {
                        return VWMergeType.getLocalizedString(fieldDef.getMergeType());
                    }
                    return this.m_dummyMergeType;
                }
                case 5: {
                    if (fieldDef != null) {
                        return fieldDef.getDescription();
                    }
                    return this.m_dummyDescription;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: 
            case 2: 
            case 3: {
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null) {
                    return wrapper.isLocal();
                }
                return true;
            }
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            if (!this.isCellEditable(nRowIndex, nColumnIndex)) {
                return;
            }
            switch (nColumnIndex + this.m_nColumnIndexOffset) {
                case 1: {
                    this.onUpdateFieldName(aValue, nRowIndex);
                    break;
                }
                case 2: {
                    this.onUpdateFieldType(aValue, nRowIndex);
                    break;
                }
                case 4: {
                    this.onUpdateFieldValue(aValue, nRowIndex);
                    break;
                }
                case 3: {
                    this.onUpdateMergeType(aValue, nRowIndex);
                    break;
                }
                case 5: {
                    this.onUpdateDescription(aValue, nRowIndex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        switch (event.getID()) {
            case 511: {
                if (event.getSource() == this) break;
                this.reinitialize();
            }
        }
    }

    private void onUpdateFieldName(Object aValue, int nRowIndex) {
        block10: {
            VWFieldDefinition fieldDef = null;
            try {
                if (aValue == null || !(aValue instanceof String)) {
                    return;
                }
                String newName = (String)aValue;
                if (newName.length() == 0) {
                    return;
                }
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && wrapper.getValue() != null) {
                    fieldDef = (VWFieldDefinition)wrapper.getValue();
                }
                if (fieldDef != null) {
                    String[] names = new String[]{fieldDef.getName(), newName};
                    fieldDef.setName(names[1]);
                    this.m_authPropertyData.setDirty();
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(names[0]);
                    this.m_changedItems.addElement(names[1]);
                    this.onRenamedField(this.m_changedItems);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 514);
                } else if (this.m_authPropertyData != null && this.m_authPropertyData.getWorkflowDefinition() != null) {
                    if (this.m_authPropertyData.getField(newName) != null) {
                        String message = VWResource.s_fieldExists.toString(newName);
                        VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), message, 1);
                        return;
                    }
                    fieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingString(newName, this.m_dummyValue, this.getFieldType(this.m_dummyType), this.isArrayType(this.m_dummyType));
                    if (fieldDef != null) {
                        fieldDef.setMergeType(this.getMergeType(this.m_dummyMergeType));
                        fieldDef.setDescription(this.m_dummyDescription);
                        this.m_authPropertyData.resetFieldCache();
                        this.m_authPropertyData.setDirty();
                        this.m_dummyValue = VWParamExpressionCellEditor.getInitialFieldValue(this.getFieldType(this.m_dummyType), this.isArrayType(this.m_dummyType));
                        this.m_dummyDescription = null;
                        this.m_rowData.addElement(new VWTableItemWrapper(0, fieldDef));
                        this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(fieldDef);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 511);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block10;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onUpdateFieldType(Object aValue, int nRowIndex) {
        VWFieldDefinition fieldDef = null;
        int nNewMergeType = -1;
        boolean bTypeChanged = true;
        try {
            block11: {
                try {
                    if (aValue == null) break block11;
                    String type = aValue.toString();
                    int fieldType = this.getFieldType(type);
                    boolean isArray = this.isArrayType(type);
                    VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                    if (wrapper != null && wrapper.getValue() != null) {
                        fieldDef = (VWFieldDefinition)wrapper.getValue();
                    }
                    if (fieldDef != null) {
                        if (fieldType == fieldDef.getFieldType() && isArray == fieldDef.isArray()) {
                            bTypeChanged = false;
                        }
                        fieldDef.setValue(fieldDef.getStringValue(), fieldType, isArray);
                        this.m_authPropertyData.setDirty();
                        nNewMergeType = this.getNewMergeType(fieldType, isArray, fieldDef.getMergeType());
                        if (nNewMergeType != -1) {
                            fieldDef.setMergeType(nNewMergeType);
                        }
                        if (bTypeChanged) {
                            String newValue = VWParamExpressionCellEditor.getInitialFieldValue(fieldType, isArray);
                            this.setValueAt(newValue, nRowIndex, this.getActualColumnIndex(4));
                        }
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(fieldDef);
                        this.onChangedField(fieldDef);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 512);
                        break block11;
                    }
                    if (this.m_dummyType != null && this.m_dummyType.equals(type)) {
                        bTypeChanged = false;
                    }
                    this.m_dummyType = type;
                    nNewMergeType = this.getNewMergeType(fieldType, isArray, this.getMergeType(this.m_dummyMergeType));
                    if (nNewMergeType != -1) {
                        this.m_dummyMergeType = VWMergeType.getLocalizedString(nNewMergeType);
                    }
                    if (!bTypeChanged) break block11;
                    String newValue = VWParamExpressionCellEditor.getInitialFieldValue(fieldType, isArray);
                    this.setValueAt(newValue, nRowIndex, this.getActualColumnIndex(4));
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var12_14 = null;
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    return;
                }
            }
            Object var12_13 = null;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onUpdateFieldValue(Object aValue, int nRowIndex) {
        try {
            block19: {
                try {
                    if (aValue == null) break block19;
                    String expression = (String)aValue;
                    VWFieldDefinition fieldDef = null;
                    VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                    if (wrapper != null && wrapper.getValue() != null) {
                        fieldDef = (VWFieldDefinition)wrapper.getValue();
                    }
                    if (fieldDef != null) {
                        if (fieldDef.getFieldType() == 4) {
                            if (VWStringUtils.compare(expression, VWResource.s_true) == 0) {
                                expression = "true";
                            } else if (VWStringUtils.compare(expression, VWResource.s_false) == 0) {
                                expression = "false";
                            }
                        }
                        if (wrapper.isInherited()) {
                            if (VWStringUtils.compare(expression, fieldDef.getStringValue()) != 0) {
                                int nMergeType = fieldDef.getMergeType();
                                String description = fieldDef.getDescription();
                                fieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingString(fieldDef.getName(), expression, fieldDef.getFieldType(), fieldDef.isArray());
                                fieldDef.setMergeType(nMergeType);
                                fieldDef.setDescription(description);
                                wrapper.overrideValue(fieldDef);
                            }
                        } else {
                            fieldDef.setValue(expression, fieldDef.getFieldType(), fieldDef.isArray());
                        }
                        this.m_authPropertyData.setDirty();
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(fieldDef);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 512);
                        break block19;
                    }
                    if (this.getFieldType(this.m_dummyType) == 4) {
                        if (this.isArrayType(this.m_dummyType)) {
                            expression = VWStringUtils.replaceAll(expression, VWResource.s_true, "true");
                            expression = VWStringUtils.replaceAll(expression, VWResource.s_false, "false");
                        } else if (VWStringUtils.compare(expression, VWResource.s_true) == 0) {
                            expression = "true";
                        } else if (VWStringUtils.compare(expression, VWResource.s_false) == 0) {
                            expression = "false";
                        }
                    }
                    this.m_dummyValue = expression;
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var9_10 = null;
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    return;
                }
            }
            Object var9_9 = null;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onUpdateMergeType(Object aValue, int nRowIndex) {
        block10: {
            block9: {
                VWFieldDefinition fieldDef = null;
                try {
                    try {
                        if (aValue == null) {
                            Object var6_4 = null;
                            break block9;
                        }
                        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                        if (wrapper != null && wrapper.getValue() != null) {
                            fieldDef = (VWFieldDefinition)wrapper.getValue();
                        }
                        if (fieldDef != null) {
                            fieldDef.setMergeType(this.getMergeType(aValue.toString()));
                            this.m_authPropertyData.setDirty();
                            this.m_changedItems = new Vector();
                            this.m_changedItems.addElement(fieldDef);
                            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 512);
                            break block10;
                        } else {
                            this.m_dummyMergeType = aValue.toString();
                        }
                        break block10;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        Object var6_6 = null;
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    throw throwable;
                }
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        Object var6_5 = null;
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onUpdateDescription(Object aValue, int nRowIndex) {
        block12: {
            block11: {
                VWFieldDefinition fieldDef = null;
                try {
                    try {
                        if (aValue == null) {
                            Object var8_4 = null;
                            break block11;
                        }
                        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                        if (wrapper != null && wrapper.getValue() != null) {
                            fieldDef = (VWFieldDefinition)wrapper.getValue();
                        }
                        if (fieldDef != null) {
                            if (wrapper.isInherited()) {
                                String currentDesc = fieldDef.getDescription();
                                if (currentDesc == null || VWStringUtils.compare(aValue.toString(), currentDesc) != 0) {
                                    int nMergeType = fieldDef.getMergeType();
                                    fieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingString(fieldDef.getName(), fieldDef.getStringValue(), fieldDef.getFieldType(), fieldDef.isArray());
                                    fieldDef.setMergeType(nMergeType);
                                    fieldDef.setDescription(aValue.toString());
                                    wrapper.overrideValue(fieldDef);
                                }
                            } else {
                                fieldDef.setDescription(aValue.toString());
                            }
                            this.m_authPropertyData.setDirty();
                            this.m_changedItems = new Vector();
                            this.m_changedItems.addElement(fieldDef);
                            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 512);
                            break block12;
                        }
                        this.m_dummyDescription = aValue.toString();
                        break block12;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        Object var8_6 = null;
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    throw throwable;
                }
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        Object var8_5 = null;
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }

    private int getMergeType(String type) {
        try {
            if (VWStringUtils.compare(type, VWMergeType.getLocalizedString(5)) == 0) {
                return 5;
            }
            if (VWStringUtils.compare(type, VWMergeType.getLocalizedString(2)) == 0) {
                return 2;
            }
            if (VWStringUtils.compare(type, VWMergeType.getLocalizedString(6)) == 0) {
                return 6;
            }
            if (VWStringUtils.compare(type, VWMergeType.getLocalizedString(1)) == 0) {
                return 1;
            }
            if (VWStringUtils.compare(type, VWMergeType.getLocalizedString(3)) == 0) {
                return 3;
            }
            if (VWStringUtils.compare(type, VWMergeType.getLocalizedString(4)) == 0) {
                return 4;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return -1;
    }

    private int getNewMergeType(int nType, boolean bIsArray, int nMergeType) {
        switch (nType) {
            case 4: 
            case 16: {
                if (bIsArray) {
                    this.m_currentMergeTypeModel = this.m_fiveMergeTypeModel;
                    break;
                }
                this.m_currentMergeTypeModel = this.m_twoMergeTypeModel;
                if (nMergeType == 1 || nMergeType == 3) break;
                return 1;
            }
            case 1: 
            case 2: 
            case 8: {
                if (bIsArray) {
                    this.m_currentMergeTypeModel = this.m_sixMergeTypeModel;
                    break;
                }
                this.m_currentMergeTypeModel = this.m_threeMergeTypeModel;
                if (nMergeType == 1 || nMergeType == 3 || nMergeType == 5) break;
                return 1;
            }
        }
        return -1;
    }

    private Object getTypeField(VWFieldDefinition fieldDef) {
        String obj = null;
        boolean isArray = false;
        String type = null;
        try {
            if (fieldDef != null) {
                isArray = fieldDef.isArray();
                type = VWFieldType.getLocalizedString(fieldDef.getFieldType());
                if (isArray) {
                    type = type + "[ ]";
                }
            } else {
                type = this.m_dummyType;
            }
            obj = type;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return obj;
    }

    private String getValueField(VWFieldDefinition fieldDef) {
        try {
            String strValue = null;
            int nFieldType = -1;
            boolean bIsArray = false;
            if (fieldDef != null) {
                strValue = fieldDef.getStringValue();
                nFieldType = fieldDef.getFieldType();
                bIsArray = fieldDef.isArray();
            } else {
                strValue = this.m_dummyValue;
                nFieldType = this.getFieldType(this.m_dummyType);
                bIsArray = this.isArrayType(this.m_dummyType);
            }
            if (nFieldType == 4) {
                if (bIsArray) {
                    strValue = VWStringUtils.replaceAll(strValue, "true", VWResource.s_true);
                    strValue = VWStringUtils.replaceAll(strValue, "false", VWResource.s_false);
                } else {
                    strValue = VWStringUtils.compare(strValue, "true") == 0 ? VWResource.s_true : VWResource.s_false;
                }
            }
            return strValue;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

